function [yUMF,uUMF,yLMF,uLMF]=antonymIT2(xUMF,uUMF,xLMF,uLMF,rightEnd)

%
% [yUMF,uUMF,yLMF,uLMF]=antonymIT2(xUMF,uUMF,xLMF,uLMF,rightEnd)
%
% function to compute the complement of an IT2 FS:
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in Making Subjective Judgments, 
% Wiley-IEEE Press, 2010.
%
% Last modified by Dongrui WU (dongruiw@usc.edu), 7/29/2009
%
% xUMF: x-coordinates of the UMF of the input IT2 FS
% uUMF: u-coordinates of the UMF of the input IT2 FS
% xLMF: x-coordinates of the LMF of the input IT2 FS
% uLMF: u-coordinates of the LMF of the input IT2 FS
% rightEnd: the right end-point for the complement. 
%
% yUMF: y-coordinates of the complement
% uUMF: u-coordinates of the complement
% yLMF: y-coordinates of the complement
% uLMF: u-coordinates of the complement

if length(xUMF)~=length(uUMF)
    display('xUMF and uUMF must have the same length.');
    return
end

if length(xLMF)~=length(uLMF)
    display('xLMF and uLMF must have the same length.');
    return
end

yUMF=rightEnd-xUMF(end:-1:1);
uUMF=uUMF(end:-1:1);
yLMF=rightEnd-xLMF(end:-1:1);
uLMF=uLMF(end:-1:1);
  
